package com.java24hours;

import java.io.*;
import java.net.*;
import java.util.*;
import jdk.incubator.http.*;

public class ServerCheck {
    public ServerCheck() {
        String[] sites = {
            "https://www.apple.com",
            "https://www.microsoft.com",
            "http://www.compaq.com",
            "http://www.hp.com",
            "https://www.oracle.com/",
            "http://www.informit.com/"
        };
        try {
            load(sites);
        } catch (URISyntaxException oops) {
            System.out.println("Złe URI: " + oops.getMessage());
        } catch (IOException | InterruptedException oops) {
            System.out.println("Błąd: " + oops.getMessage());
        }
    }
    
    public void load(String[] sites) throws URISyntaxException, IOException,
            InterruptedException {
        
        for (String site : sites) {
            System.out.println("\nStrona: " + site);
            // Utwórz klienta sieciowego
            HttpClient browser = HttpClient.newHttpClient();
            // Zbuduj żądanie dotyczące strony
            URI uri = new URI(site);
            HttpRequest.Builder bob = HttpRequest.newBuilder(uri);
            HttpRequest request = bob.build();
            // Wyślij żądanie
            HttpResponse<String> response = browser.send(request,
                HttpResponse.BodyHandler.asString());
            // Odszukaj nagłówek z informacjami o serwerze
            HttpHeaders headers = response.headers();
            Optional<String> server = headers.firstValue("Server");
            if (server.isPresent()) {
                System.out.println("Serwer: " + server.get());
            } else {
                System.out.println("Serwer nieokreślony");
            }
        }
    }
    
    public static void main(String[] arguments) {
        new ServerCheck();
    }
}

